function [data,cdata] = prop_sum()
%A stupid little function that will open up some AT lists from find_imgprop
%remove the outliers and write out a new file with some math.  Was
%improp_fltr.
%Synatax:   [data,cdata] = prop_sum(); 
%Input:     none right now
%Output:    data = the total data from all the opened files as 1 matrix.
%           cdata = the array of results from the math applied to data.

%open the index file: the file where the outliers are to be found
[filename_tmp,pathname_tmp,filterindex] = uigetfile2({'*.csv','Text files (*.csv)';'*.*','All Files';},...
    'Open CSV','Multiselect','off');
%create a consolidated holding place for the file path and name.
filename{1,1} = filename_tmp;
pathname{1,1} = pathname_tmp;

%now open the rest of the files
[filename_tmp,pathname_tmp,filterindex] = uigetfile2({'*.csv','Text files (*.csv)';'*.*','All Files';},...
    'Open CSVs','Multiselect','on');
%consolidate the file names
filename = horzcat(filename,filename_tmp);
pathname = horzcat(pathname,pathname_tmp);

data = [];
%now open up the data files, and concatenate them.
for i = 1:size(filename,2)
    if i==1     %read first file
        data_tmp = single(dlmread([pathname{1,1},filename{1,i}],',',1,0));
    else        %read all the rest
        data_tmp = single(dlmread([pathname{1,2},filename{1,i}],',',1,0));
    end
    data = horzcat(data,data_tmp);
end

%now find the outliers and remove the data
%first calculate our criteria
out = std(data(:,1))*5;     %5 times the standard deviation should do it.
[x,y] = find(data(:,1)>out);        %find the outliers.
data(x,:) = [];             %remove the outliers

%do some math on the data
cdata(1,:) = mean(data);
cdata(2,:) = std(data);
cdata(3,:) = repmat(size(data,1),1,size(data,2));
cdata(4,:) = median(data);

%localization for macs
if ispc
    slash = '\';        %Windows directory marker
else
    slash = '/';        %Mac directory marker
end

%now save the data
csv_exp = dataset(data);               %to export as a CSV need to make the data a dataset.
export(csv_exp,'File',[[pathname{1,2}(1,1:end-1),slash],'data.csv'],'delimiter',',')
csv_exp = dataset(cdata);               %to export as a CSV need to make the data a dataset.
export(csv_exp,'File',[[pathname{1,2}(1,1:end-1),slash],'mathdata.csv'],'delimiter',',')
